-- jeli funkcja o takiej nazwie ju istnieje, to j usu
IF OBJECT_ID (N'dbo.getWeeks') IS NOT NULL
   DROP function dbo.getWeeks
GO
-- utwrz funkcj zwracajca tabel z 2 kolumnami
-- paramter 1: pocztkowa data analizowanego okresu
-- paramter 2: kocowa data analizowanego okresu
-- paramter 3: flaga, okreslajca, czy docz do wynikw niepene tygodnie
-- paramter 4: dzie pocztku tygodnia, 1 - niedziela
CREATE FUNCTION [dbo].[getWeeks] (@FROM DATETIME, @TO DATETIME, @INCLUDE_PARTS BIT, @WEEK_START smallint)
RETURNS  @WEEKS TABLE
(
	START smalldatetime, 
	[END] smalldatetime
)
AS 
BEGIN
-- zmienne pomocnicze
	DECLARE @END smalldatetime, @POM smalldatetime

-- cofnicie si do pocztku tygodnia rozpoczynajcego podany okres
	SET @POM = DATEADD(dd, DATEPART(dy, @FROM) - DATEPART(dw, @FROM) +  @WEEK_START - 1, 
						CONVERT(datetime, CONVERT(char(4), DATEPART(yyyy,@FROM)) + '-01-01')
                       )
-- jeli jestemy w podanym oknie czasowym, to wstaw do tabeli wynikowej 
-- informacje o pocztku i kocu tygodnia
	WHILE @POM <= @TO 
	BEGIN
        SET @END = DATEADD(dd, 6, @POM)

        IF @INCLUDE_PARTS = 1 OR (@POM >= @FROM AND @END <= @TO) 
		BEGIN
            INSERT INTO @WEEKS VALUES (@POM, @END)
        END
        SET @POM= DATEADD (wk, 1, @POM)
    END
    
    RETURN
END
